# getDirectoryToWatchFailedLookupLocationIndir

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Posix root: /

## RootDirForResolution: /

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/dir                                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/dir                                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/dir                                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/dir                                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/dir                                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |                                                                                              |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |                                                                                              |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |                                                                                              |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |                                                                                              |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |                                                                                              |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |                                                                                              |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |                                                                                              |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/dir/somefile.d.ts                                                                | /workspaces/dir                                                                              | true      |                                                                                              |
| /workspaces/folderAtRoot/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/dir                                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | true      |                                                                                              |

